/*****************************************************************************/
/* ctrl.rsc  THE Control Panel Resource File.				     */
/*			copyright (c) 1985 by Atari Corp.	  	     */
/*	Combined into one big mess. 3/7/89 .. RZ		  	     */
/*****************************************************************************/
#define CTRL_WID 248
#define CTRL_HI  171

#define NUM_COBJS 63

/*****************************************************************************/
/* Control Panel Elements						     */
/*****************************************************************************/

#define CROOT	0

#define	RTOP	1
#define	GTOP	2
#define	BTOP	3

#define	RBOT	10
#define	GBOT	11
#define	BBOT	12

#define	RMIX	4
#define	GMIX	6
#define	BMIX	8
#define	HMIX	98
#define	HSLDR	12

#define	RMIX_SL	5
#define	GMIX_SL	7
#define	BMIX_SL	9

#define	CLR0	13
#define	CLR1	14
#define	CLR2	15
#define	CLR3	16
#define	CLR4	17
#define	CLR5	18
#define	CLR6	19
#define	CLR7	20
#define	CLR8	21
#define	CLR9	22
#define	CLRA	23
#define	CLRB	24
#define	CLRC	25
#define	CLRD	26
#define	CLRE	27
#define	CLRF	28

#define	IRPT	40
#define	IRPT_BX	42
#define	IRPT_SL	43
#define	IRPT_MG	41
#define	KRPT	44
#define	KRPT_BX	46
#define	KRPT_SL	47
#define	KRPT_MG	45
#define	WRPT	116
#define	WSLDR	7

#define	MBOX0	54
#define	MBOX1	55
#define	MBOX2	56
#define	MBOX3	57
#define	MBOX4	58

#define	TIME	29
#define	DATE	30

#define	CLICK	50
#define	BELL	52
#define	CLICK_BX 49
#define	BELL_BX	51

#define	RS232	61
#define	PRINTER	62

#define	CANCEL	53

#define	COLORS	120	/* the y location of the color boxes */

/*****************************************************************************/
/* Control Panel object structures and associated data			     */
/*****************************************************************************/
char	rmix_str[3] = "Rd";
char	gmix_str[3] = "Gr";
char	bmix_str[3] = "Bl";

#if USA
char	time[6] = "1250P";		/* 12 hour time */
char	date[7] = " 72085";		/* month/day/year */
TEDINFO texts[] = {
time, "__:__ _M","9999F", IBM, S_ONLY, 2, 0x1180, 0, 1, 6,9,
date,"__/__/__","999999", IBM, S_ONLY, 2, 0x1180, 0, 1, 7,9,
rmix_str,"__","nn", IBM, S_ONLY, 2, 0x2100, 0, 2, 2,2,
gmix_str,"__","nn", IBM, S_ONLY, 2, 0x3100, 0, 2, 2,2,
bmix_str,"__","nn", IBM, S_ONLY, 2, 0x4100, 0, 2, 2,2,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1
};

#endif
#if UK
char	time[6] = "1250P";		/* 12 hour time */
char	date[7] = "20 785";		/* day/month/year */
TEDINFO texts[] = {
time, "__:__ _M","9999F", IBM, S_ONLY, 2, 0x1180, 0, 1, 6,9,
date,"__/__/__","999999", IBM, S_ONLY, 2, 0x1180, 0, 1, 7,9,
rmix_str,"__","nn", IBM, S_ONLY, 2, 0x2100, 0, 2, 2,2,
gmix_str,"__","nn", IBM, S_ONLY, 2, 0x3100, 0, 2, 2,2,
bmix_str,"__","nn", IBM, S_ONLY, 2, 0x4100, 0, 2, 2,2,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1
};
#endif
#if SWEDEN|FINLAND|ARABIC
char	time[5] = "1533";		/* mil time */
char	date[7] = "87 720";		/* year/month/day */
TEDINFO texts[] = {
time, "__:__","9999", IBM, S_ONLY, 2, 0x1180, 0, 1, 5,6,
date,"__-__-__","999999", IBM, S_ONLY, 2, 0x1180, 0, 1, 7,9,
rmix_str,"__","nn", IBM, S_ONLY, 2, 0x2100, 0, 2, 2,2,
gmix_str,"__","nn", IBM, S_ONLY, 2, 0x3100, 0, 2, 2,2,
bmix_str,"__","nn", IBM, S_ONLY, 2, 0x4100, 0, 2, 2,2,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1
};
#endif
#if GERMAN|FRENCH|ITALY|SPAIN|TURKEY|NORWAY|DENMARK
char	time[5] = "1533";		/* mil time */
char	date[7] = "20 787";		/* day/month/year*/
TEDINFO texts[] = {
time, "__:__","9999", IBM, S_ONLY, 2, 0x1180, 0, 1, 5,6,
date,"__/__/__","999999", IBM, S_ONLY, 2, 0x1180, 0, 1, 7,9,
rmix_str,"__","nn", IBM, S_ONLY, 2, 0x2100, 0, 2, 2,2,
gmix_str,"__","nn", IBM, S_ONLY, 2, 0x3100, 0, 2, 2,2,
bmix_str,"__","nn", IBM, S_ONLY, 2, 0x4100, 0, 2, 2,2,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1,
"R","_","n",IBM,S_ONLY,2,0x1072,0,1,1,1,
"G","_","n",IBM,S_ONLY,2,0x1073,0,1,1,1,
"B","_","n",IBM,S_ONLY,2,0x1074,0,1,1,1
};
#endif

int	presson[] = {
	0x0410,0x0410,0x0410,0x0410,0x0410,0x0410,0x0710,0x0490,
	0x04B0,0x0CAE,0x1BC2,0x3006,0x7FFA,0x4016,0x401A,0x4016
};

int	pressup[] = {
	0x0410,0x0410,0x0710,0x0490,0x04B0,0x0CAE,0x1BC6,0x300A,
	0x7FF6,0x401A,0x4016,0x401A,0x4016,0x401A,0x4016,0x401A
};

int	rabbit[] = {
	0x0000,0x0000,0x0000,0x0000,0x0600,0x0E00,0x1CE0,0x1BF0,
	0x3FF4,0x3FFC,0x37BC,0x0378,0x06F0,0x0000,0x0000,0x0000
};

int	turtle[] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0700,0x1AC6,0x356E,
	0x6AAC,0x5578,0x7FF0,0x1860,0x1860,0x1C70,0x0000,0x0000
};

int	resting[] = {
	0x00FF,0xFF00,0x0080,0x0100,0x0080,0x0100,0x0080,0x0100,
	0x0080,0x6100,0x0003,0x6100,0x01E7,0xE100,0x07F7,0xF100,
	0x0FFB,0xF900,0x1FFE,0xFD00,0x1FFF,0xFD00,0x3FFF,0xE100,
	0x3FFF,0x7100,0x2FE7,0x9900,0x30F9,0xC100,0x1C1C,0x1F00,
	0x0600,0x0000,0x0100,0x0000,0x0000,0x0000
};

int	active[] = {
	0xFFFF,0x0000,0x8001,0x0000,0x8601,0x0000,0x86C1,0x0000,
	0x8FE1,0x0000,0x9FE1,0x0000,0xBEC1,0x0000,0xBF01,0x0000,
	0x87C1,0x0000,0x87E1,0x0C00,0x8FF1,0x3200,0x9FF9,0x6100,
	0x97FC,0xC000,0x85FD,0x8000,0x81FF,0x8000,0xFCFF,0x0000,
	0x03BE,0x0000,0x0078,0x0000,0x01E0,0x0000
};

int	clickon[] = {
	0xFFFF,0xFFFF,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8FD0,0x0BF1,0x8800,0x0011,0x8BC0,0x03D1,0x8A00,0x0051,
	0x8AFF,0xFF51,0x8A80,0x0351,0x88C0,0x0511,0x80FF,0xF901,
	0x88F0,0x0911,0x80F3,0xC901,0x80F6,0x6901,0x80F6,0x0901,
	0x80F6,0x0901,0x80F6,0x0901,0x80F6,0x6901,0x88F3,0xC911,
	0x80F0,0x0901,0x88DF,0xF911,0x8ABF,0xFD51,0x8AFF,0xFF51,
	0x8A00,0x0051,0x8BC0,0x03D1,0x8800,0x0011,0x8FD0,0x0BF1,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0xFFFF,0xFFFF
};

int	clickoff[] = {
	0xFFFF,0xFFFF,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8055,0x5501,0x8080,0x0201,0x8040,0x0501,0x80AA,0xA801,
	0x8050,0x0101,0x80A2,0x8801,0x8054,0x4101,0x80A2,0x0801,
	0x8054,0x0101,0x80A2,0x0801,0x8054,0x4101,0x80A2,0x8801,
	0x8050,0x0101,0x80AA,0xA801,0x8055,0x5501,0x80AA,0xAA01,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0xFFFF,0xFFFF
};

int	bellon[] = {
	0xFFFF,0xFFFF,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8019,0xCC01,0x8133,0x6641,
	0x8366,0x3361,0x8244,0x1121,0x8244,0x1121,0x8244,0x1121,
	0x8244,0x1121,0x84CC,0x1991,0x8198,0x0CC1,0x8330,0x0661,
	0x83BF,0xFEE1,0x8001,0x0001,0x8003,0x8001,0x8003,0x8001,
	0x8001,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0xFFFF,0xFFFF
};

int	belloff[] = {
	0xFFFF,0xFFFF,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,	
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8001,0x4001,0x8002,0xA001,
	0x8005,0x5001,0x8002,0xA001,0x8005,0x5001,0x8002,0xA001,
	0x8005,0x5001,0x800A,0xA801,0x8015,0x5401,0x802A,0xAA01,
	0x8015,0x5401,0x8000,0x0001,0x8001,0x0001,0x8002,0x8001,
	0x8001,0x0001,0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0001,0xFFFF,0xFFFF
};

int	slider[] = {
	0x2800,
	0x2800,
	0x2800,
	0x6c00,
	0x6c00,
	0xee00,
	0xee00,
	0xee00,
	0xee00,
	0xee00,
	0xee00,
	0x6c00,
	0x6c00,
	0x2800,
	0x2800,
	0x2800
};


BITBLK	stamps[] = {
	presson, 2, 16, 0, 0, 1,
	pressup, 2, 16, 0, 0, 1,
	rabbit, 2, 16, 0, 0, 1,
	turtle, 2, 16, 0, 0, 1,
	resting, 4, 19, 0, 0, 1,
	active, 4, 19, 0, 0, 1,
	clickon, 4, 32, 0, 0, 1,
	clickoff, 4, 32, 0, 0, 1,
	bellon, 4, 32, 0, 0, 1,
	belloff, 4, 32, 0, 0, 1,
	slider, 2, 16, 0, 0, 0
};


OBJECT ctrl_objs[] = {
-1, 1, 62, G_BOX, NONE, NORMAL, 0x1100L, 0,0, CTRL_WID, CTRL_HI,

/*	color mixing boxes					*/

 2, -1, -1, G_BOXTEXT,NONE,NORMAL,&texts[5],0,0,24,10,
 3, -1, -1, G_BOXTEXT,NONE,NORMAL,&texts[6],24,0,24,10,
 4, -1, -1, G_BOXTEXT,NONE,NORMAL,&texts[7],48,0,24,10,
 6,  5,  5, G_BOX, NONE, NORMAL, 0x011100L, 0,10, 24,HMIX,
 4, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, &texts[2], 0,16, 24,HSLDR,
 8,  7,  7, G_BOX, NONE, NORMAL, 0x011100L, 24,10, 24,HMIX,
 6, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, &texts[3], 0,24, 24,HSLDR,
10,  9,  9, G_BOX, NONE, NORMAL, 0x011100L, 48,10, 24,HMIX,
 8, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, &texts[4], 0,40, 24,HSLDR,
11, -1, -1, G_BOXTEXT, NONE,NORMAL,&texts[8],0,108,24,10,
12, -1, -1, G_BOXTEXT, NONE,NORMAL,&texts[9],24,108,24,10,
13, -1, -1, G_BOXTEXT, NONE,NORMAL,&texts[10],48,108,24,10,

/* These are the colored boxes near the bottom of the ctrl panel	*/

14, -1, -1, G_BOX, NONE, NORMAL, 0x011170L, 4,COLORS, 24,20,
15, -1, -1, G_BOX, NONE, NORMAL, 0x030171L, 4,COLORS+20, 24,20,
16, -1, -1, G_BOX, NONE, NORMAL, 0x030172L, 35,COLORS, 24,20,
17, -1, -1, G_BOX, NONE, NORMAL, 0x030173L, 35,COLORS+20, 24,20,
18, -1, -1, G_BOX, NONE, NORMAL, 0x030174L, 66,COLORS, 24,20,
19, -1, -1, G_BOX, NONE, NORMAL, 0x030175L, 66,COLORS+20, 24,20,
20, -1, -1, G_BOX, NONE, NORMAL, 0x030176L, 97,COLORS, 24,20,
21, -1, -1, G_BOX, NONE, NORMAL, 0x030177L, 97,COLORS+20, 24,20,
22, -1, -1, G_BOX, NONE, NORMAL, 0x030178L, 128,COLORS, 24,20,
23, -1, -1, G_BOX, NONE, NORMAL, 0x030179L, 128,COLORS+20, 24,20,
24, -1, -1, G_BOX, NONE, NORMAL, 0x03017aL, 159,COLORS, 24,20,
25, -1, -1, G_BOX, NONE, NORMAL, 0x03017bL, 159,COLORS+20, 24,20,
26, -1, -1, G_BOX, NONE, NORMAL, 0x03017cL, 190,COLORS, 24,20,
27, -1, -1, G_BOX, NONE, NORMAL, 0x03017dL, 190,COLORS+20, 24,20,
28, -1, -1, G_BOX, NONE, NORMAL, 0x03017eL, 221,COLORS, 24,20,
29, -1, -1, G_BOX, NONE, NORMAL, 0x03017fL, 221,COLORS+20, 24,20,

/*	time and date boxes					*/

30, -1, -1, G_FBOXTEXT, 0x0e, NORMAL, &texts[0], 72,0, 88,18,
31, -1, -1, G_FBOXTEXT, 0x0c, NORMAL, &texts[1], 160,0, 88,18,

/*	key repeat speed boxes					*/

48, 32, 44, G_BOX, NONE, NORMAL, 0xFF1171L, 72,18, 176,40,
34, 33, 33, G_BOX, NONE, NORMAL, 0xFF1100L, 7,2, 20,16,
32, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[1], 2,0, 16,12,
36, 35, 35, G_BOX, NONE, NORMAL, 0xFF1100L, 145,2, 20,16,
34, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[0], 2,0, 16,12,
38, 37, 37, G_BOX, NONE, NORMAL, 0xFF1100L, 7,22, 20,16,
36, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[2], 2,0, 16,12,
40, 39, 39, G_BOX, NONE, NORMAL, 0xFF1100L, 145,22, 20,16,
38, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[3], 2,0, 16,12,
44, 41, 42, G_BOX, NONE, NORMAL, 0x011171L, 28,2, WRPT,16,
42, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[10], 0,0, WSLDR,15,
40, 43, 43, G_BOX, NONE, NORMAL, 0x0L, 0,6, WRPT,4,
42, -1, -1, G_BOX, NONE, NORMAL, 0x071L, 24,0, WSLDR,4,
31, 45, 46, G_BOX, NONE, NORMAL, 0x011171L, 28,22, WRPT,16,
46, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[10], 0,0, WSLDR,15,
44, 47, 47, G_BOX, NONE, NORMAL, 0x0L, 0,6, WRPT,4,
46, -1, -1, G_BOX, NONE, NORMAL, 0x071L, 24,0, WSLDR,4,

/*	noise boxes and cancel					*/

54, 49, 53, G_BOX, NONE, NORMAL, 0x11141L, 72,82, 176,36,
51, 50, 50, G_BOX, NONE, NORMAL, 0x11100L, 8,2, 32,32,
49, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[9], 0,0, 32,32,
53, 52, 52, G_BOX, NONE, NORMAL, 0x11100L, 48,2,  32,32,
51, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[6], 0,0, 32,32,

#if USA | UK
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Cancel", 96,10, 64,16,
#endif
#if GERMAN
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "NEUSTART", 88,10, 80,16,
#endif
#if FRENCH
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Annuler", 88,10, 80,16,
#endif
#if ITALY
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Annulla", 88,10, 80,16,
#endif
#if SPAIN
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Cancela", 88,10, 80,16,
#endif
#if TURKEY
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "\235ptal", 88,10, 80,16,
#endif
#if SWEDEN
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "B\231RJA OM", 88,10, 80,16,
#endif
#if FINLAND
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Kumoa", 88,10, 80,16,
#endif
#if NORWAY
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Avbryt", 88,10, 80,16,
#endif
#if DENMARK
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Afbryd", 88,10, 80,16,
#endif
#if ARABIC
48, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "", 88,10, 48,16,
#endif

/*	mouse speed boxes					*/

55, -1, -1, G_BUTTON, 0x11, NORMAL, "0", 109,62, 16,16,
56, -1, -1, G_BUTTON, 0x11, NORMAL, "1", 130,62, 16,16,
57, -1, -1, G_BUTTON, 0x11, NORMAL, "2", 151,62, 16,16,
58, -1, -1, G_BUTTON, 0x11, NORMAL, "3", 172,62, 16,16,
59, -1, -1, G_BUTTON, 0x11, NORMAL, "4", 193,62, 16,16,
60, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[4], 76,62, 24,19,
61, -1, -1, G_IMAGE, NONE, NORMAL, &stamps[5], 216,62, 24,19,

#if USA | UK
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "RS232 Config.", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Install Printer",128,161,118,8
#endif					  
#if GERMAN
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "RS232-Parameter", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Drucker-Daten",128,161,118,8
#endif
#if FRENCH
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Instal RS232", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Instal Imprim",128,161,118,8
#endif
#if ITALY
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Config. RS232", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Inst. Stampante",128,161,118,8
#endif
#if SWEDEN
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "St\204ll in RS232", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "V\204lj skrivartyp",128,161,118,8
#endif
#if FINLAND
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "RS232 asetukset", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Kirjoitin...",128,161,118,8
#endif
#if NORWAY
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "RS232 konfig.", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Skriver...",128,161,118,8
#endif
#if SPAIN
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Configura RS232", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Fija impresora",128,161,118,8
#endif
#if TURKEY
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "RS232 D\201zeni", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Yaz\236c\236 Ba\252lama",128,161,118,8
#endif
#if DENMARK
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Indstil RS232", 1,161, 120,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "Tilpas Printer",126,161,120,8
#endif
#if ARABIC
62, -1, -1, G_BUTTON, SELECTABLE, NORMAL, "  ʢ ", 2,161, 118,8,
0, -1, -1, G_BUTTON, SELECTABLE, NORMAL, " ",128,161,118,8
#endif                                    
};

/************************************************************************/
/* vt52.rsc    M.S.	4/3/85		     				*/
/*			copyright Atari Corp	1985,1986		*/
/************************************************************************/

/************************************************************************/
/*	RS-232 Configuration Equates					*/
/************************************************************************/
#define ACC_WID		300
#define ACC_HI 		144
#define RSOK		36
#define RSCANCEL	37
#define NUM_RSOBJ	38
#define	SEL_BAUD	11
#define	END_BAUD	14
#define	SEL_PARITY	16
#define	END_PARITY	18
#define	SEL_DUPLEX	20
#define	SEL_BCHAR	23
#define	END_BCHAR	26
#define	SEL_XON		31
#define	SEL_RTS		34
#define	SEL_BIT		28
#define DUPLEX		0
#define BAUD		1
#define PARITY		2
#define BCHAR		3
#define FLOW		4
#define STBIT		5
#define NUM_OBS 	3
#define	DNARROW		SEL_BAUD+1
#define	FAKEBOX		SEL_BAUD	/* This box is a filler so I do not */
#define	BAUDIND		SEL_BAUD+2	/* have to reindex the object struc */
#define	UPARROW		END_BAUD

/************************************************************************/
/*	RS-232 Configuration Dialogue box .. International versions	*/
/************************************************************************/
#if	USA | UK
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "RS232 PORT CONFIGURATION",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baud Rate:",16,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Parity:",40,32,56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex:",40,44,56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/Char:",16,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Strip Bit:",16,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Flow Control",96,82,96,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "None",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Cancel",220,130,56,8
};
#endif
#if	GERMAN
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "RS232 KONFIGURATION",80,7,152,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baud Rate:",16,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Parit\204t:",32,32,56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex:",40,44,56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/Zchn:",16,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Bit 8:",48,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Kommunikationsparameter",56,82,184,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "Keine",0,0,48,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",52,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",96,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Voll",0,0,48,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Halb",52,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,48,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",52,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",96,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",140,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "An",0,0,48,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Aus",52,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "An",0,0,48,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Aus",52,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "An",0,0,48,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Aus",52,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,64,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "ABBRUCH",224,130,64,8
};
#endif
#if	ITALY
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "CONFIGURAZIONE PORTA RS 232",48,7,216,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baud Rate:",16,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Parit\205:",40,32,56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex:",40,44,56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bit/car:",32,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Bit 8:",48,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Controllo Transmissione",56,82,176,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "None",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",52,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",96,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",52,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",52,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",96,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",140,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "No",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Yes",52,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "No",0,0,48,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Yes",52,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "No",0,0,48,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Yes",52,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,64,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Annulla",224,130,64,8
};
#endif
#if	FRENCH
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "CONFIGURATION RS232",72,7,152,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Bauds:",48,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Parit\202:",40,32,56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex:",40,44,56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/Car:",24,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Strip Bit:",16,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Commande Flux",96,82,102,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "Rien",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Imp.",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Pair",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "Confirmer",18,130,72,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Annuler",204,130,72,8
};
#endif
#if	SPAIN
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "CONFIGURA RS232",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baudios  :",16,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Paridad  :",16,32,80,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex   :",16,44,80,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/Char:",16,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Strip Bit:",16,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Protocolos",96,82,96,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "None",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "Si",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "No",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "Si",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "No",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "Si",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "No",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "Conforme",18,130,64,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Cancela",220,130,64,8
};
#endif
#if	TURKEY
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "RS232 D\201zeni",96,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baud Rate:",16,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Parity:",40,32,56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex:",40,44,56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/Char:",16,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Strip Bit:",16,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Ak\236\247 Kontrolu",96,82,96,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "None",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "Tamam",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "\235ptal",220,130,56,8
};
#endif
#if	SWEDEN
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Inst\204llning av RS232-porten",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Baud     :",4,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Paritet  :",4,32,80,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Duplex   :",4,44,80,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bitar/tkn:",4,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Bit 8    :",4,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "\231verf\224ringskontroll",4,82,152,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff:",24,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "Rts/Cts:",32,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "Ingen",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Udda",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "J\204mn",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Halv",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Avbryt",220,130,56,8
};
#endif
#if	FINLAND
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "RS232 asetukset",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "  Nopeus :",4,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Pariteet :",4,32,80,8,
5, -1, -1, G_STRING, NONE, NORMAL, "  Duplex :",4,44,80,8,
6, -1, -1, G_STRING, NONE, NORMAL, " bit/mrk :",4,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Stop bit :",4,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, " K\204ttely :",96,82,152,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff :",4,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, " Rts/Cts :",4,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "None",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Odd",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Even",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Half",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "On",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Off",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Kumoa",220,130,56,8
};
#endif
#if	NORWAY
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Innstilling av RS232-porten",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "    Baud :",4,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, " Paritet :",4,32,80,8,
5, -1, -1, G_STRING, NONE, NORMAL, "  Duplex :",4,44,80,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Bits/tegn:",4,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "   Bit 8 :",4,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Overf\263ringskontroll:",56,82,152,8,
9, -1, -1, G_STRING, NONE, NORMAL, "Xon/Xoff :",4,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, " Rts/Cts :",4,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "Ingen",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Ulik",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Lik",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Full",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Halv",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "P\206",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Av",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "AVBRYT",220,130,56,8
};
#endif
#if	DENMARK
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Indstilling af RS232-porten",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, "      Baud:",4,20,80,8,
4, -1, -1, G_STRING, NONE, NORMAL, "   Paritet:",4,32,80,8,
5, -1, -1, G_STRING, NONE, NORMAL, "    Duplex:",4,44,80,8,
6, -1, -1, G_STRING, NONE, NORMAL, " Bits/tegn:",4,56,80,8,
7, -1, -1, G_STRING, NONE, NORMAL, "   Stopbit:",4,68,80,8,
8, -1, -1, G_STRING, NONE, NORMAL, "Overf\263ringskontrol:",56,82,152,8,
9, -1, -1, G_STRING, NONE, NORMAL, "  Xon/Xoff:",4,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, "   Rts/Cts:",4,110,64,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,106,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "19200",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,106,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, "Ingen",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Ulige",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "Lige",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,106,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Fuld",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Halv",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,106,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "8",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "7",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "6",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "5",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,106,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "Til",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "Fra",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,106,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "Til",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "Fra",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,106,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "Til",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "Fra",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "OK",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "AFBRYD",220,130,56,8
};
#endif
#if     ARABIC
OBJECT rs_objs[] = {
-1,1,NUM_RSOBJ-1, G_BOX, NONE, NORMAL | OUTLINED, 0x21000L,0,0,ACC_WID,ACC_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "  ʢ  ",56,7,192,8,
3, -1, -1, G_STRING, NONE, NORMAL, ": ",220,20,64,8,
4, -1, -1, G_STRING, NONE, NORMAL, ":",236,32,48,8,
5, -1, -1, G_STRING, NONE, NORMAL, ":",236,44,48,8,
6, -1, -1, G_STRING, NONE, NORMAL, ":/",212,56,72,8,
7, -1, -1, G_STRING, NONE, NORMAL, ": ",196,68,88,8,
8, -1, -1, G_STRING, NONE, NORMAL, " ",96,82,96,8,
9, -1, -1, G_STRING, NONE, NORMAL, ":Xon/Xoff",212,96,72,8,
10, -1, -1, G_STRING, NONE, NORMAL, ":Rts/Cts",212,110,72,8,
15, 11, 14, G_IBOX, NONE, NORMAL, 0x100L,8,20,172,8,
12, -1, -1, G_IBOX,  NONE, NORMAL,0x100L,80,0,40,8,
13, -1, -1, G_BUTTON, 0x51, NORMAL, "\002", 0,0,10,8,
14, -1, -1, G_BUTTON, NONE, NORMAL, "",15,0,40,8,
10, -1, -1, G_BUTTON, 0x51, NORMAL, "\001", 60,0,10,8,
19, 16, 18, G_IBOX, NONE, NORMAL, 0x100L,8,32,130,8,
17, -1, -1, G_BUTTON, 0x11, NORMAL, " ",0,0,40,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "",44,0,40,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, " ",88,0,40,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L ,8,44,130,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "",0,0,40,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "",44,0,40,8,
27, 23, 26, G_IBOX, NONE, NORMAL, 0x100L,8,56,172,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "",0,0,40,8,
25, -1, -1, G_BUTTON, 0x11, NORMAL, "",44,0,40,8,
26, -1, -1, G_BUTTON, 0x11, NORMAL, "",88,0,40,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "",132,0,40,8,
30, 28, 29, G_IBOX, NONE, NORMAL, 0x100L,8,68,172,8,
29, -1, -1, G_BUTTON, 0x11, NORMAL, "on",0,0,40,8,
27, -1, -1, G_BUTTON, 0x11, NORMAL, "off",44,0,40,8,
33, 31, 32, G_IBOX, NONE, NORMAL, 0x100L,8,96,130,8,
32, -1, -1, G_BUTTON, 0x11, NORMAL, "on",0,0,40,8,
30, -1, -1, G_BUTTON, 0x11, NORMAL, "off",44,0,40,8,
36, 34, 35, G_IBOX, NONE, NORMAL, 0x100L,8,110,130,8,
35, -1, -1, G_BUTTON, 0x11, NORMAL, "on",0,0,40,8,
33, -1, -1, G_BUTTON, 0x11, NORMAL, "off",44,0,40,8,
37, -1, -1, G_BUTTON, 0x5, NORMAL, "",18,130,56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "  ",220,130,56,8
};
#endif

/*****************************************************************************/
/* printer.rsc  A Control Panel Resource File.				     */
/*			copyright (c) 1985 by Atari Corp.	  	     */
/*****************************************************************************/

/************************************************************************/
/*	Printer Configuration Equates					*/
/************************************************************************/
#define PRTR_WID 296
#define PRTR_HI  112
#define NUM_POBJS 28

#define OK	26
#define CNCL	27

/************************************************************************/
/*	Printer Configuration Dialogue box .. International versions	*/
/************************************************************************/
#if USA | UK
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Printer Type:", 4,20, 104,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pixels/Line:", 12,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Printer Port:", 4,68, 104,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Paper Type:",  20,80, 88,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Color:", 60,32, 48,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Quality:", 44,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Dot", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Daisy", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "B/W", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Color", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Draft", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Final", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Printer", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Feed", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Single", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "INSTALL PRINTER", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Cancel", 188,96, 56,8};
#endif
#if GERMAN
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Drucker Typ:", 12,20, 104,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Punkte/Zeile:", 4,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Drucker Port:", 4,68, 104,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Papier Typ:",  20,80, 88,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Farbe:", 60,32, 48,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Qualit\204t:", 36,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "MATRIX", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "TYPENRAD", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "S/W", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "FARBE", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "TEST", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "MAXIMUM", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "PRINTER", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "MODEM", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "ENDLOS", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "EINZEL", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "DRUCKER ANPASSUNG", 80,4, 136,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "ABBRUCH", 188,96, 56,8};
#endif
#if ITALY
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Tipo:", 68,20, 104,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Punti/Linea:", 12,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Porta:", 60,68, 104,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Carta:", 60,80, 88,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Colore:", 52,32, 48,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Qualit\205:", 44,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Punti", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Caratt.", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "B/N", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Colore", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Bozza", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Finale", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Stamp.", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Continuo", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Singolo", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "CONFIG. STAMPANTE", 80,4, 136,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Annulla", 188,96, 56,8};
#endif
#if FRENCH
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Type:", 68,20, 104,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pixels/Ligne:", 4,44, 104,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Sortie:", 52,68, 56,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Papier:", 52,80, 56,8,
6, -1, -1, G_STRING, NONE, NORMAL, "Couleur:", 44,32, 64,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Qualit\202:", 44,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Matri.", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Margue.", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "N/B", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Couleur", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Epreuve", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "D\202finit.", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Imprim.", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Continu", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Feuille", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "INSTAL. IMPRIMANTE", 72,4, 144,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "Confirmer", 40,96, 72,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Annuler", 184,96, 72,8};
#endif
#if SWEDEN
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Skrivartyp :",    4,20, 96,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pixels/rad :",    4,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Skrivarport:",    4,68, 96,8,
5, -1, -1, G_STRING, NONE, NORMAL, "Papperstyp :",    4,80, 96,8,
6, -1, -1, G_STRING, NONE, NORMAL, "F\204rg       :", 4,32, 96,8,
7, -1, -1, G_STRING, NONE, NORMAL, "Kvalitet   :",    4,56, 96,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Matris", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Typhjul", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "S/V", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "F\204rg", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Enkel", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "H\224gsta", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Printer", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Bana", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Ark", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "SKRIVARANPASSNING", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Avbryt", 188,96, 56,8};
#endif
#if FINLAND
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "      Tyyppi :",    4,20, 96,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pisteet/Rivi :",    4,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "    Liit\204nt\204 :",    4,68, 96,8,
5, -1, -1, G_STRING, NONE, NORMAL, "      Paperi :",    4,80, 96,8,
6, -1, -1, G_STRING, NONE, NORMAL, "        V\204ri :", 4,32, 96,8,
7, -1, -1, G_STRING, NONE, NORMAL, "       Laatu :",    4,56, 96,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Matriisi", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Kiekko", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "M/V", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "V\204ri", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Vedos", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Valmis", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Printer", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Jatko", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Arkki", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "KIRJOITIN...", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Kumoa", 188,96, 56,8};
#endif
#if NORWAY
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, " Skrivertype :",    4,20, 96,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pixels/Linje :",    4,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, " Skriverport :",    4,68, 96,8,
5, -1, -1, G_STRING, NONE, NORMAL, "   Papirtype :",    4,80, 96,8,
6, -1, -1, G_STRING, NONE, NORMAL, "      Farger :", 4,32, 96,8,
7, -1, -1, G_STRING, NONE, NORMAL, "    Kvalitet :",    4,56, 96,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Matrise", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Typehjul", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "S/H", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Farger", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Matrise", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Brevkv.", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Skriver", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Bane", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Ark", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "SKRIVERTILPASSNING...", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Avbryt", 188,96, 56,8};
#endif
#if DENMARK
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, " Printertype: ",    4,20, 96,8,
3, -1, -1, G_STRING, NONE, NORMAL, "Pixels/linie: ",    4,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, " Printerport: ",    4,68, 96,8,
5, -1, -1, G_STRING, NONE, NORMAL, "   Papirtype: ",    4,80, 96,8,
6, -1, -1, G_STRING, NONE, NORMAL, "       Farve: ", 4,32, 96,8,
7, -1, -1, G_STRING, NONE, NORMAL, "    Kvalitet: ",    4,56, 96,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Matrix", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Typehjul", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "S/H", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Farger", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Test", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Endelig", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Printer", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Baner", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Enkelt", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "PRINTERTILPASNING...", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "OK", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Afbryd", 188,96, 56,8};
#endif
#if TURKEY
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "  Yaz\236c\236 Tipi:", 4,20, 104,8,
3, -1, -1, G_STRING, NONE, NORMAL, " Nokta/Sat\236r:", 12,44, 96,8,
4, -1, -1, G_STRING, NONE, NORMAL, "Yaz\236c\236 \200\236k\236\247\236:", 4,68, 104,8,
5, -1, -1, G_STRING, NONE, NORMAL, " Ka\252\236t Tipi:", 20,80, 86,8,
6, -1, -1, G_STRING, NONE, NORMAL, "  Renk:", 60,32, 48,8,
7, -1, -1, G_STRING, NONE, NORMAL, "  Kalite:", 44,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Nokta", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Papatya", 100,0, 69,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "S/B", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Renkli", 100,0, 69,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 100,0, 69,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Taslak", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Son", 100,0, 69,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Yaz\236c\236", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Modem", 100,0, 69,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "S\201rekli", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Tek", 100,0, 69,8,
26, -1, -1, G_STRING, NONE, NORMAL, "YAZICI BA\251LAMA", 88,4, 101,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "Tamam", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "\235ptal", 188,96, 56,8};
#endif
#if SPAIN
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, "Impresora   :", 4, 20, 104, 8,
3, -1, -1, G_STRING, NONE, NORMAL, "Puntos/Linea:", 4, 44, 104, 8,
4, -1, -1, G_STRING, NONE, NORMAL, "Puerta      :", 4, 68, 104, 8,
5, -1, -1, G_STRING, NONE, NORMAL, "Tipo papel  :", 4, 80, 104, 8,
6, -1, -1, G_STRING, NONE, NORMAL, "Tipo        :", 4, 32, 104, 8,
7, -1, -1, G_STRING, NONE, NORMAL, "Calidad     :", 4, 56, 104, 8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 112,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "Aguja", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, "Daisy", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 112,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "B/N", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, "Color", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 112,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "1280", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "960", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 112,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "Normal", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "Final", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 112,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "Paralelo", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, "Serie", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 112,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "Continuo", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, "Hojas", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "FIJA IMPRESORA", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "Conforme", 80,96, 64,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "Cancela", 188,96, 64,8};
#endif
#if ARABIC
OBJECT prnt_objs[] = {
-1, 1, 27, G_BOX, NONE, OUTLINED, 0x21100L, 0,0, PRTR_WID,PRTR_HI,
2, -1, -1, G_STRING, NONE, NORMAL, ": ", 188,20, 96,8,
3, -1, -1, G_STRING, NONE, NORMAL, ":/", 204,44, 80,8,
4, -1, -1, G_STRING, NONE, NORMAL, ":", 180,68, 104,8,
5, -1, -1, G_STRING, NONE, NORMAL, ": ", 204,80, 80,8,
6, -1, -1, G_STRING, NONE, NORMAL, ":", 236,32, 48,8,
7, -1, -1, G_STRING, NONE, NORMAL, ":", 220,56, 64,8,
10, 8, 9, G_IBOX, NONE, NORMAL, 0x100L, 0,20, 180,8,
9, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
7, -1, -1, G_BUTTON, 0x11, NORMAL, " ", 104,0, 64,8,
13, 11, 12, G_IBOX, NONE, NORMAL, 0x100L, 0,32, 180,8,
12, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
10, -1, -1, G_BUTTON, 0x11, NORMAL, " ", 104,0, 64,8,
16, 14, 15, G_IBOX, NONE, NORMAL, 0x100L, 0,44, 180,8,
15, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
13, -1, -1, G_BUTTON, 0x11, NORMAL, "", 104,0, 64,8,
19, 17, 18, G_IBOX, NONE, NORMAL, 0x100L, 0,56, 180,8,
18, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
16, -1, -1, G_BUTTON, 0x11, NORMAL, "", 104,0, 64,8,
22, 20, 21, G_IBOX, NONE, NORMAL, 0x100L, 0,68, 180,8,
21, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
19, -1, -1, G_BUTTON, 0x11, NORMAL, " ", 104,0, 64,8,
25, 23, 24, G_IBOX, NONE, NORMAL, 0x100L, 0,80, 180,8,
24, -1, -1, G_BUTTON, 0x11, NORMAL, "", 8,0, 64,8,
22, -1, -1, G_BUTTON, 0x11, NORMAL, " ", 104,0, 64,8,
26, -1, -1, G_STRING, NONE, NORMAL, "  ", 88,4, 120,8,
27, -1, -1, G_BUTTON, 0x5, NORMAL, "", 80,96, 56,8,
0, -1, -1, G_BUTTON, 0x27, NORMAL, "  ", 188,96, 56,8};
#endif
